<?php

/**
 * This creates custom shortcodes
 * 
 * https://codex.wordpress.org/Shortcode_API
 * 
 */

// Sample Shortcode
function featured_blogs_function() {

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => '-1',
        'order_by' => 'date',
        'category_name' => 'featured',
    );

    $query = new WP_Query($args);
    if( $query->have_posts() ):
        ob_start(); 
    ?>
    
        <div class="featured-blogs">
        
            <!-- Loop Start -->
            <?php while( $query->have_posts() ): $query->the_post(); ?>

                <div class="blog">
                    <?php
						if ( has_post_thumbnail() ) {
							the_post_thumbnail( 'medium', array( 'class' => 'img-responsive' ) );
						}
					?>

                    <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>

                    <p><?php the_excerpt(); ?></p>

                </div>
                
            <?php endwhile; ?>
            <!-- Loop End -->
        
        </div>

    <?php

    endif;
    $output_string = ob_get_contents();
	ob_end_clean();
	wp_reset_postdata();
	return $output_string;

}
add_shortcode( 'featured_blogs', 'featured_blogs_function' );