jQuery(document).ready(function($) {
    $('.tab-btn').on('click', function() {
        var officeID = $(this).data('cat');

        _load_team_by_office(officeID);
    });

    function _load_team_by_office(officeID) {
        $.ajax({
            url: team_ajax_obj.ajax_url,
            type: 'POST',
            data: {
                action: 'load_team_by_office',
                office_id: officeID
            },
            beforeSend: function(jqXHR, settings) {
                $('#team-list').html('<span class="custom-loader"></span>');
                $('.tab-btn').removeClass('active');
            },
            success: function(response) {
                $('#team-list').html(response);
                $('.tab-btn[data-cat="' + officeID + '"]').addClass('active');

            },
            error: function(jqXHR, textStatus, errorThrown) {
                // Display an error message
                console.error("Error:", errorThrown);
            }
        });
    }_load_team_by_office(0);

});
