<?php 

/**
 * Enqueue scripts and styles.
 */
// function enqueue_team_scripts() {
//     wp_enqueue_script('team-ajax', get_template_directory_uri() . '/assets/js/team-ajax.js', array('jquery'), null, true);
//     wp_localize_script('team-ajax', 'team_ajax_obj', array(
//         'ajax_url' => admin_url('admin-ajax.php'),
//     ));
// }
// add_action('wp_enqueue_scripts', 'enqueue_team_scripts');

/**
 * Handle AJAX
 */
function load_team_by_office() {
    $office_id = intval($_POST['office_id']);

    if ($office_id === 0) {
        $query = new WP_Query(array(
            'post_type' => 'team'
        ));
    }else {
        $query = new WP_Query(array(
            'post_type' => 'team',
            'tax_query' => array(array(
                'taxonomy' => 'team_office',
                'field' => 'term_id',
                'terms' => $office_id,
            )),
        ));
    }
    

    if ($query->have_posts()) {
        echo '<div class="team-inner">';
        while ($query->have_posts()) {
            $query->the_post();
            echo get_template_part( 'template-parts/team/content', 'excerpt' );
        }
        echo '</div>';
    } else {
        echo '<p>No items found in this category.</p>';
    }

    wp_die();
}
add_action('wp_ajax_load_team_by_office', 'load_team_by_office');
add_action('wp_ajax_nopriv_load_team_by_office', 'load_team_by_office');


/**
 * Populate ACF field for team meber position with taxonomy terms.
 */
add_filter('acf/load_field/name=member_position', 'populate_taxonomy_terms');
function populate_taxonomy_terms( $field ) {

    // Reset choices to avoid duplicates
    $field['choices'] = array();

    // Get all terms from your custom taxonomy
    $terms = get_terms( array(
        'taxonomy'   => 'team_position', // Replace with your taxonomy slug
        'hide_empty' => false,
    ) );

    // If terms were found
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ) {
        // Loop through each term
        foreach ( $terms as $term ) {
            // Add the term to the select field's choices
            $field['choices'][ $term->slug ] = $term->name;
        }
    }

    // Return the field
    return $field;
}

/**
 * Hide the team position metabox.
 */
function hide_teamposition_metabox() {
	remove_meta_box( 'team_positiondiv', 'team', 'normal' );
}
add_action( 'admin_menu' , 'hide_teamposition_metabox' );

/**
 * Custom Shortcodes
 */
function display_team_member_funtion(){
    return '<p>No items found in this category.</p>';
}add_shortcode('dispay_team_member', 'display_team_member_funtion');

?>