<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'wp5default' ); ?></a>

	<header id="masthead" class="site-header main">
		<div class="container">
			<div class="header-wrapper">
				<div class="hdLogo">
					<?php the_custom_logo(); ?>
				</div>
				<div class="header-menu">
					<div class="header-navigation">
						<?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
					</div>
					<div class="header-info">
						<a href="tel: <?php if ( checkoption( 'phone' ) ): echo do_shortcode('[wp5default_option var="phone" type="text"]'); endif; ?>" class="btn btn-phone"><i class="fa fa-phone icon" aria-hidden="true"></i></a>
					</div>
				</div>
			</div>
		</div>
	</header><!-- #masthead -->
	

	<div id="banner" class="site-banner">
		<?php if (is_active_sidebar( 'site-banner' ) && !is_404() && is_front_page() ): ?>
			<?php dynamic_sidebar( 'site-banner' ); ?>
		<?php else: ?>
			<?php if ( checkoption( 'banner_image' ) ): ?>
				<?php echo do_shortcode('[wp5default_option var="banner_image" type="image" text=""]'); ?>
				<?php if ( !is_404() ): ?>
					<?php if( get_field('hide_title') ): ?>
						<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
					<?php endif; ?>
					<?php if( is_home() || is_single() ): ?>
						<h1 class="entry-title"><?php echo get_the_title(get_option('page_for_posts')) ?></h1>
					<?php endif; ?>
				<?php else: ?>
					<h1 class="entry-title">404</h1>
				<?php endif; ?>
			<?php else: ?>
				<?php dynamic_sidebar( 'site-banner' ); ?>
			<?php endif; ?>
		<?php endif; ?>
	</div><!-- .site-banner -->


	<div id="<?php echo !is_front_page() ? "content" : 'front'?>" class="site-content">
		<!-- <div class="container">
			<div class="row"> -->
