<?php
/**
 * WP Default Custom Post Types Sample
 *
 * @package WP_Default
 */

/**
 * Create team post type
 */
function scwd_create_team_post_type() {

	$labels = array(
		'name'					=> __( 'Teams' ),
		'singular_name'			=> __( 'Team' ),
		'add_new'				=> __( 'New Team' ),
		'add_new_item'			=> __( 'Add New Team' ),
		'edit_item'				=> __( 'Edit Team' ),
		'new_item'				=> __( 'New Team' ),
		'view_item'				=> __( 'View Team' ),
		'search_items'			=> __( 'Search Teams' ),
		'not_found'				=>  __( 'No Teams Found' ),
		'not_found_in_trash'	=> __( 'No Teams found in Trash' ),
	);
	$args = array(
		'labels'		=> $labels,
		'has_archive'	=> true,
		'public'		=> true,
		'hierarchical'	=> false,
		'rewrite'		=> array( 'slug' => 'team' ),
		'supports'		=> array(
			'title',
			'editor',
			// 'excerpt',
			'custom-fields',
			'thumbnail',
			'page-attributes'
		),
		'taxonomies'	=> array( 'post_tag' ),
		"menu_icon"	=> "dashicons-groups",
	);
	register_post_type( 'team', $args );

}
add_action( 'init', 'scwd_create_team_post_type' );

/**
 * Create team post type taxonomy
 */
function scwd_register_team_taxonomy() {

	$labels = array(
		'name'				=> __( 'Positions'),
		'singular_name'		=> __( 'Position'),
		'search_items'		=> __( 'Search Positions'),
		'all_items'			=> __( 'All Positions'),
		'edit_item'			=> __( 'Edit Position'),
		'update_item'		=> __( 'Update Position'),
		'add_new_item'		=> __( 'Add New Position'),
		'new_item_name'		=> __( 'New Position Name'),
		'menu_name'			=> __( 'Positions'),
	);

	$args = array(
		'labels'			=> $labels,
		'hierarchical'		=> true,
		'sort'				=> true,
		'args'				=> array( 'orderby' => 'term_order' ),
		'rewrite'			=> array( 'slug'    => 'team-position' ),
		'show_admin_column'	=> true,
	);

	register_taxonomy( 'team_position', array( 'team' ), $args);

	$labels = array(
		'name'				=> __( 'Offices'),
		'singular_name'		=> __( 'Office'),
		'search_items'		=> __( 'Search Offices'),
		'all_items'			=> __( 'All Offices'),
		'edit_item'			=> __( 'Edit Office'),
		'update_item'		=> __( 'Update Office'),
		'add_new_item'		=> __( 'Add New Office'),
		'new_item_name'		=> __( 'New Office Name'),
		'menu_name'			=> __( 'Offices'),
	);

	$args = array(
		'labels'			=> $labels,
		'hierarchical'		=> true,
		'sort'				=> true,
		'args'				=> array( 'orderby' => 'term_order' ),
		'rewrite'			=> array( 'slug'    => 'team-office' ),
		'show_admin_column'	=> true,
	);

	register_taxonomy( 'team_office', array( 'team' ), $args);

}
add_action( 'init', 'scwd_register_team_taxonomy' );