<?php
/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */

get_header();
?>

	<section id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="row">
				<div class="new-search-form">
					<h3>New Search</h3>
					<?php get_search_form();?>
				</div>
				<div class="search-result">
					<?php if ( have_posts() ) : ?>
						<?php 
								global $wp_query;
								//echo $wp_query->found_posts . '&nbsp;' . __('results found', 'theme-text-domain');
						?>
						<header class="page-header">
							<h2 class="page-title">
								<?php _e( $wp_query->found_posts . " " . 'SEARCH RESULT FOR:' . " " . get_search_query(), 'wp5default' ); ?>
							</h2>
							<!-- <div class="page-description"><?php   ?></div> -->
						</header><!-- .page-header -->
						<ul>
							<?php
							// Start the Loop.
							while ( have_posts() ) :
								the_post();

								/*
								* Include the Post-Format-specific template for the content.
								* If you want to override this in a child theme, then include a file
								* called content-___.php (where ___ is the Post Format name) and that will be used instead.
								*/
								get_template_part( 'template-parts/content/content', 'excerpt' );

								// End the loop.
							endwhile;

							// Previous/next page navigation.
							wp5default_the_posts_navigation();

							// If no content, include the "No posts found" template.
							else :

							get_template_part( 'template-parts/content/content', 'none' );			
					endif; ?>
					</ul>
				</div>
			</div>
		</main><!-- #main -->
	</section><!-- #primary -->

<?php
get_footer();
