<?php
/**
 * Template part for displaying post archives and search results
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-header">
		<div class="post-thumbnail">
			<?php the_post_thumbnail(); ?>
		</div>
		<?php
			the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );
		?>
	</div>

	<div class="entry-content">
		

		<div class="section">
			<h3>Name</h3>
			<h5><?php echo esc_html( get_field('member_name') ); ?></h5>
		</div>
		<div class="section">
			<h3>Bio</h3>
			<?php the_excerpt(); ?>
		</div>
		<a href="<?php echo esc_url( get_permalink() ); ?>" class="btn">Read More</a>
	</div><!-- .entry-content -->

	
</article><!-- #post-${ID} -->
