<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<div class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</div>

	<div class="entry-content">
		<div class="group-section">
			<div class="col">
				<div class="section">
					<h3>Name</h3>
					<h5><?php echo esc_html( get_field('member_name') ); ?></h5>
				</div>
				<div class="section">
					<h3>Position</h3>
					<h5 class="text-capitalize has-icon"><i class="fa fa-gamepad icon" aria-hidden="true"></i>  <?php echo esc_html( get_field('member_position') ); ?></h5>
				</div>
				<div class="section">
					<h3>Contact Information</h3>
					<ul>
						<li><i class="fa fa-envelope icon" aria-hidden="true"></i> <a href="<?php echo esc_url( 'mailto:' . antispambot( get_field('member_email') ) ); ?>"><?php echo esc_html( get_field('member_email') ); ?></a></li>
						<li><i class="fa fa-phone icon" aria-hidden="true"></i> <a href="<?php echo esc_url( 'tel:' . antispambot( get_field('member_contact') ) ); ?>"><?php echo esc_html( get_field('member_contact') ); ?></a></li>
					</ul>
				</div>
			</div>
			<div class="col">
				<div class="post-thumbnail">
					<?php the_post_thumbnail(); ?>
				</div>
			</div>
		</div>
		<div class="section">
			<h3>Bio</h3>
			<?php
				the_content(
					sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'wp5default' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					)
				);

				wp_link_pages(
					array(
						'before' => '<div class="page-links">' . __( 'Pages:', 'wp5default' ),
						'after'  => '</div>',
					)
				);
			?>
		</div>
		<div class="section">
			<h3>Recent Photos</h3>
			<?php 
				if ( !empty(get_field('member_gallery') ) ) {
					echo get_field('member_gallery');
				} else {
					echo "<p>No Gallery Available</p>";
				}
			?>
		</div>
		<a href="<?php echo esc_url( get_post_type_archive_link('team') ); ?>" class="btn">Go Back</a>
	</div><!-- .entry-content -->

</article><!-- #post-${ID} -->
