<?php
/**
 * Copyright 2010-2013 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 * http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

/**
 * Generic exception thrown by the SNS Message Validator.
 */
class SnsMessageValidatorException extends RuntimeException {}


/**
 * Indicates that certificate was from an unrecognized source.
 */
class CertificateFromUnrecognizedSourceException extends SnsMessageValidatorException {}

/**
 * Indicates that the public key can't be extracted from the the certificate.
 */
class CannotGetPublicKeyFromCertificateException extends SnsMessageValidatorException {}


/**
 * Indicates that the signature for SNS message was invalid.
 */
class InvalidMessageSignatureException extends SnsMessageValidatorException {}