<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */

get_header();
?>

	<div id="primary" class="content-area">
		<main id="main" class="site-main" role="main">
			<section class="error-404 not-found">
				<header class="page-header">
				    <p><?php the_custom_logo(); ?></p>
				    <h2>404</h2>
					<h1 class="page-title"><?php esc_html_e( 'Oops! That page can&rsquo;t be found.', 'wp5default' ); ?></h1>
				</header>
				<div class="page-content">
					<p><?php esc_html_e( 'It looks like nothing was found at this location. Maybe try to search?', 'wp5default' ); ?></p>
					<?php get_search_form();?>
				    <p>Please <a href="contact">contact</a> the administrator if you think this is a mistake.</p>
				</div>
			</section>
		</main>
	</div>

<?php
get_footer();
