<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */

?>	
			<div class="clearfix"></div>
			</div><!-- #row -->
		</div><!-- #container -->
	</div><!-- #content -->

	<footer id="colophon" class="site-footer">
		<div class="ftTouch">
			<div class="container">
				<div class="row">
					<?php if ( checkoption( 'footer_title' ) ): ?>
					<h2><?php echo do_shortcode('[wp5default_option var="footer_title" type="text"]');?></h2>
					<?php endif; ?>
					<div class="ftTouchRow">
						<p class="ftLogo">
							<?php if ( checkoption( 'footer_logo' ) ): 
								echo do_shortcode('[wp5default_option var="footer_logo" type="image" text=""]');
							endif; ?>
						</p>
						<p class="ftEmail">
							<?php if ( checkoption( 'email_label' ) ): ?>
								<strong>
									<?php echo do_shortcode('[wp5default_option var="email_label" type="text"]'); ?>
								</strong> 
							<?php endif; ?>
							<?php if ( checkoption( 'email' ) ): 
								echo do_shortcode('[wp5default_option var="email" type="link" text="" link_type="email"]');
							endif; ?>
						</p>
						<p class="ftPhone">
							<?php if ( checkoption( 'phone_label' ) ): ?>
								<strong>
									<?php echo do_shortcode('[wp5default_option var="phone_label" type="text"]'); ?>
								</strong> 
							<?php endif; ?>
							<?php if ( checkoption( 'phone' ) ): 
								echo do_shortcode('[wp5default_option var="phone" type="link" text="" link_type="phone"]');
							endif; ?>
						</p>	
					</div>
					<?php //get_template_part( 'template-parts/navigation/navigation', 'social' ); ?>
				</div>
			</div>
		</div>
		<div class="ftNav">
			<div class="container">
				<div class="row">
					<div class="navigation-bottom">
						<?php get_template_part( 'template-parts/navigation/navigation', 'bottom' ); ?>
					</div>
				</div>
			</div>
		</div>
		<div class="ftCopy">
			<div class="container">
				<div class="row">
					<?php get_template_part( 'template-parts/footer/site', 'info' ); ?>
				</div>
			</div>
		</div>
	</footer><!-- #colophon -->

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
