<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage WP5_Default
 * @since 1.0.0
 */
?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<link rel="profile" href="https://gmpg.org/xfn/11" />
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'wp5default' ); ?></a>

	<header id="masthead" class="site-header main">
		<div class="hdTop">
			<div class="container">
				<div class="row">
					<div class="hdTopLeft">
					<?php if ( has_custom_logo() ) : ?>
						<div class="hdLogo"><?php the_custom_logo(); ?></div>
					<?php endif; ?>
					</div>
					<div class="hdTopRight">
						<p class="hdEmail">
							<?php if ( checkoption( 'email_label' ) ): ?>
								<strong>
									<?php echo do_shortcode('[wp5default_option var="email_label" type="text"]'); ?>
								</strong> 
							<?php endif; ?>
							<?php if ( checkoption( 'email' ) ): 
								echo do_shortcode('[wp5default_option var="email" type="link" text="" link_type="email"]');
							endif; ?>
						</p>
						<p class="hdPhone">
							<?php if ( checkoption( 'phone_label' ) ): ?>
								<strong>
									<?php echo do_shortcode('[wp5default_option var="phone_label" type="text"]'); ?>
								</strong> 
							<?php endif; ?>
							<?php if ( checkoption( 'phone' ) ): 
								echo do_shortcode('[wp5default_option var="phone" type="link" text="" link_type="phone"]');
							endif; ?>
						</p>					
					</div>
				</div>
			</div>
		</div>
		<div class="hdBot">
			<div class="container">
				<div class="row">
					<div class="navigation-top">
						<?php get_template_part( 'template-parts/navigation/navigation', 'top' ); ?>
					</div>
				</div>
			</div>
		</div>
	</header><!-- #masthead -->
	

	<?php if ( is_active_sidebar( 'site-banner' ) && is_front_page() ) : ?>
		<div id="banner" class="site-banner">
			<div class="container">
				<div class="row">
					<?php dynamic_sidebar( 'site-banner' ); ?>
				</div>
			</div>
		</div><!-- .site-banner -->
	<?php endif; ?>

	<div id="<?php echo !is_front_page() ? "content" : 'front'?>" class="site-content">
		<div class="container">
			<div class="row">
